using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class SHIPPING_DETAILDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public SHIPPING_DETAILDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public SHIPPING_DETAIL GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 SHIPPING_DETAIL_ID)
		{
			SHIPPING_DETAIL objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_SHIPPING_DETAIL_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, SHIPPING_DETAIL_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<SHIPPING_DETAIL> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<SHIPPING_DETAIL> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_SHIPPING_DETAIL_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

        public List<SHIPPING_DETAIL> GetItemsByActivity(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID)
        {
            List<SHIPPING_DETAIL> objReturn = null;

            try
            {
                using (EFRDBDataContext dbContext = GetEfrDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_SHIPPING_DETAIL_getitemsByActivity(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, SHIPPING_DETAIL objSave)
		{
			Int32? objReturn = objSave.SHIPPING_DETAIL_ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_SHIPPING_DETAIL_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.COMMENT_TEXT, DateTime.Now, objSave.CREATEDBY, objSave.EXPECTED_RETURN_DATE, objSave.RECEIVED_DATE, objSave.REFERRAL_ID, objSave.REGISTRY_DEMOGRAPHICS_ID, objSave.REPRESENTATIVE_NAME, objSave.SEND_DATE, ref objReturn, objSave.STD_REGISTRY_ID, objSave.STD_SHIPMENTSTS_ID, objSave.STD_SHIPMENTTYPE_ID, objSave.STD_SHIPMETHOD_ID, objSave.STDSHIPMENTTYPE_ID, objSave.SURVEY_RECEIVED_FLAG, objSave.TRACKING_NUMBER, DateTime.Now, objSave.UPDATEDBY, objSave.WKF_CASE_ACTIVITY_ID);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 SHIPPING_DETAIL_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_SHIPPING_DETAIL_delete(CURRENT_USER, CURRENT_REGISTRY_ID, SHIPPING_DETAIL_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
